/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModelHandle;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;

public class MessageParameterDisplayModelRTF
extends RectangleElementsDisplayModel
implements MessageDisplayModel {
    protected int fCharSetID;
    protected MessageDisplayModelHandleRTF fMessageHandle;
    protected MessageParameter fMessageParameter;
    private static final String UNKNOWN_ELEMENT = "UnknownDisplayElementType";
    private transient String errExceedMaxCountString;

    public MessageParameterDisplayModelRTF(MessageParameter messageParameter, int charSetID) {
        super(new Dimension(0, 0));
        this.fMessageParameter = messageParameter;
        this.fCharSetID = charSetID;
        this.fMessageHandle = new MessageDisplayModelHandleRTF(this);
        this.fMessageHandle.setMessageParameter(messageParameter);
    }

    public MessageParameterDisplayModelRTF(MessageParameter messageParameter, int charSetID, int nullObject) {
        this(messageParameter, charSetID);
    }

    public DisplayElement[][] getDisplayElementsClone() {
        DisplayElement[][] ret = new DisplayElement[this.fDisplayDimension.width][this.fDisplayDimension.height];
        for (int i = 0; i < this.fDisplayDimension.width; ++i) {
            for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                ret[i][j] = this.fDisplayElements[i][j];
            }
        }
        return ret;
    }

    protected boolean canPut(DisplayElement displayElement, Point destination) {
        if (!this.checkElementRestriction(displayElement)) {
            return false;
        }
        return super.canPut(displayElement, destination);
    }

    public boolean checkElementRestriction(DisplayElement displayElement) {
        this.errExceedMaxCountString = null;
        if (this.fMessageParameter != null && displayElement != null && !(displayElement instanceof DefaultDisplayElement) && this.getParameterItemCount(displayElement) >= this.getMaxItemCount(displayElement)) {
            this.errExceedMaxCountString = "ExccedMaxCountError." + this.getDisplayElementTypeString(displayElement);
            return false;
        }
        return true;
    }

    private int getParameterItemCount(DisplayElement newDisplayElement) {
        int ret = 0;
        DisplayElement disp = null;
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                disp = this.fDisplayElements[x][y];
                if (!this.getDisplayElementTypeString(disp).equals(this.getDisplayElementTypeString(newDisplayElement))) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getMaxItemCount(DisplayElement displayElement) {
        int ret = 0;
        Hardware hardware = this.fMessageParameter.getBlock().getHardware();
        if (hardware != null) {
            String elementType = this.getDisplayElementTypeString(displayElement);
            ret = elementType.equals(UNKNOWN_ELEMENT) ? 0 : hardware.getIntProperty(elementType);
        }
        return ret;
    }

    private String getDisplayElementTypeString(DisplayElement displayElement) {
        String ret = null;
        ret = displayElement instanceof ParameterItem ? (this.isBlockParameter(displayElement) ? "RTFMaxMessageParameterItem" : "RTFMaxDataTimeItem") : (displayElement instanceof BarDisplayElement ? "RTFMaxBarGraphItem" : (displayElement instanceof AIDisplayElement ? "RTFMaxAIFilterItem" : (displayElement instanceof IONameDisplayElement ? "RTFMaxIOStatusItem" : (displayElement instanceof ScaleTimeDisplayElement ? "RTFMaxTimeScale" : UNKNOWN_ELEMENT))));
        return ret;
    }

    private boolean isBlockParameter(DisplayElement element) {
        return element instanceof ParameterItem && !(((ParameterItem)element).getParameter() instanceof MessageParameter);
    }

    public String getErrorInsertString() {
        if (this.errExceedMaxCountString != null) {
            String elementType = this.errExceedMaxCountString.substring(this.errExceedMaxCountString.indexOf(46));
            if (elementType.endsWith("RTFMaxMessageParameterItem")) {
                return "dialog.parameter.message.countInTextErrParam";
            }
            if (elementType.endsWith("RTFMaxDataTimeItem")) {
                return "dialog.parameter.message.countInTextErrDateTime";
            }
            if (elementType.endsWith("RTFMaxBarGraphItem")) {
                return "dialog.parameter.message.countInTextErrBar";
            }
            if (elementType.endsWith("RTFMaxAIFilterItem")) {
                return "dialog.parameter.message.countInTextErrAI";
            }
            if (elementType.endsWith("RTFMaxIOStatusItem")) {
                return "dialog.parameter.message.countInTextErrIO";
            }
            return "Unkown reason";
        }
        return null;
    }

    public MessageParameter getMessageParameter() {
        return this.fMessageParameter;
    }

    private void verifyVerticalBars() {
        DisplayElement displayElement = null;
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            for (int x = 0; x < this.fDisplayDimension.width; ++x) {
                displayElement = this.fDisplayElements[x][y];
                if (!(displayElement instanceof BarDisplayElement) || ((BarDisplayElement)displayElement).getDirection() != 1) continue;
                this.verifyVerticalBar(x, y, (BarDisplayElement)displayElement);
            }
        }
    }

    private void verifyVerticalBar(int xPos, int yPos, BarDisplayElement bar) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 1; y < bar.getLength(); ++y) {
                if (this.fDisplayElements[xPos + x][yPos + y] == null) continue;
                this.fDisplayElements[xPos + x][yPos + y] = null;
            }
        }
    }

    public int getCharSetID() {
        return this.fCharSetID;
    }

    public int getCharSet() {
        if (this.fMessageParameter.getMessageRTFs()[this.fCharSetID] != null) {
            return this.fMessageParameter.getMessageRTFs()[this.fCharSetID].getMessageLineRTF()[0].getCharacterSet();
        }
        return this.fMessageParameter.getBlock().getWiringDiagram().getMessageGlobalInfo().getSelectedCharSet(this.fCharSetID);
    }

    public void setDisplayElemets(DisplayElement[][] displayElements) {
        for (int i = 0; i < this.fDisplayDimension.width; ++i) {
            for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                this.fDisplayElements[i][j] = displayElements[i][j];
            }
        }
    }

    public void addAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.addAsParameterSetListener(msgParam);
    }

    public void removeAsParameterSetListener(MessageParameter msgParam) {
        this.fMessageHandle.removeAsParameterSetListener(msgParam);
    }

    public Hashtable getSpecialCharactersTable() {
        return this.fMessageHandle.getSpecialCharactersTable();
    }

    public static class MessageDisplayModelHandleRTF
    extends MessageDisplayModelHandle {
        public MessageDisplayModelHandleRTF(AbstractDisplayModel model) {
            super(model);
        }

        private MessageParameterDisplayModelRTF getDisplayModelRTF() {
            if (this.fDisplayModel instanceof MessageParameterDisplayModelRTF) {
                return (MessageParameterDisplayModelRTF)this.fDisplayModel;
            }
            return null;
        }

        public void setMessageParameter(MessageParameter messageParameter) {
            this.setDisplayDimension(messageParameter);
            if (messageParameter.getMessageRTF(this.getDisplayModelRTF().fCharSetID) != null) {
                MessageLineRTF[] messageLines = messageParameter.getMessageRTF(this.getDisplayModelRTF().fCharSetID).getMessageLineRTF();
                DisplayElement displayElement = null;
                for (int y = 0; y < messageLines.length; ++y) {
                    int x = 0;
                    while (x < this.getDisplayModelRTF().fDisplayDimension.width) {
                        displayElement = messageLines[y].getDisplayElement(x);
                        this.getDisplayModelRTF().setElementAt(displayElement, new Point(x, y));
                        if (displayElement != null) {
                            x += displayElement.getWidth();
                            continue;
                        }
                        ++x;
                    }
                }
                this.getDisplayModelRTF().verifyVerticalBars();
            }
        }

        private void setDisplayDimension(MessageParameter messageParameter) {
            int columns = 0;
            columns = ((MessageParameterDisplayModelRTF)this.fDisplayModel).isBiWidthCharacterset() ? 32 : 24;
            this.fDisplayModel.setDisplayDimension(new Dimension(columns, 4));
        }
    }
}

